function cb_m13
% Menu 13
% Basic parameters

  global persParamsDir
  global y
  global Ls                   
  global ns                   
  global plf                  
  global isHumSuppression     
  global Rs
  global isCrosstalkComp
  global td
  global fs
  global sfontsize
  global m13
  
  kw=20/sfontsize;
  capt = get(m13,'label');  
  rowscols = [1,30*kw; 1,30*kw; 1,30*kw; 1,30*kw; 1,30*kw; 1,30*kw];
  prompt={};
  prompt{1} = 'Signal level / dBFS';
  prompt{2} = 'Number of sweeps';
  prompt{3} = 'Powerline frequency / Hz';
  prompt{4} = 'Suppresss hum? (0 = no, 1 = yes)';
  prompt{5} = 'Rsense / kOhm';
  prompt{6} = 'Compensate crosstalk? (0 = no, 1 = yes)'; 
  defaults{1} = num2str(Ls,4);
  defaults{2} = num2str(ns,4);
  defaults{3} = num2str(plf,4);
  defaults{4} = num2str(isHumSuppression);
  defaults{5} = num2str(Rs/1000,5); 
  defaults{6} = num2str(isCrosstalkComp);    
  
  result= inputdlg (prompt, capt, rowscols, defaults);
  
  if ~isempty(result)    
    num=real(str2num(result{1}));    
    if ~isempty(num)
      Ls=num(1,1);
      if (Ls < -60) Ls = -60; end
      if (Ls > -0.5) Ls = -0.5; end
    end 
    num=real(str2num(result{2})); 
    if ~isempty(num)   
      ns=round((num(1,1)));
      if (ns < 1) ns = 1; end
      if (ns >32) ns = 32; end 
    end 
    num=real(str2num(result{3})); 
    if ~isempty(num)        
      plf=num(1,1);
      if (plf < 40) plf = 40; end
      if (plf > 80) plf = 80; end
    end 
    num=real(str2num(result{4}));    
    if ~isempty(num)          
      isHumSuppression=num(1,1);
      if (isHumSuppression <0.5) isHumSuppression = false; end
      if (isHumSuppression >=0.5) isHumSuppression = true; end
    end
    num=real(str2num(result{5}));     
    if ~isempty(num)            
      Rs=num(1,1)*1000;
      if (Rs <100) Rs = 100; end 
      if (Rs >10e6) Rs = 10e6; end 
    end      
    num=real(str2num(result{6}));    
    if ~isempty(num)          
      isCrosstalkComp=num(1,1);
      if (isCrosstalkComp <0.5) isCrosstalkComp = false; end
      if (isCrosstalkComp >=0.5) isCrosstalkComp = true; end
    end
    sn = strcat(persParamsDir,'basicParams.mat');
    save('-mat',sn, 'Ls', 'ns','plf', 'isHumSuppression', 'Rs', 'isCrosstalkComp');
    if plf >55 
      td = 494/fs;
    else
      td = 593/fs;
    end
    y = testsignal;  % recalculates the testsignal for Ls, ns and plf changes 
  end
end